#include <iostream>
#include <algorithm>
#include <vector>
#include <iomanip>
using namespace std;
#define ll long long

struct freelancer
{
	double income;
	double max_tax;
};

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	int n; cin >> n;
	vector<freelancer> freelancers(n);
	for (size_t i = 0; i < n; i++)
		cin >> freelancers[i].income >> freelancers[i].max_tax;
	
	sort(freelancers.begin(), freelancers.end(), [](const freelancer& lhs, const freelancer& rhs) {return lhs.max_tax > rhs.max_tax; });

	double max_profit = -1;
	double current_income_sum = 0;
	for (size_t i = 0; i < n; i++)
	{
		current_income_sum += freelancers[i].income;
		double current_profit = current_income_sum * freelancers[i].max_tax/100.0;
		max_profit = max(max_profit, current_profit);
	}
	
	cout << setprecision(5) << fixed << max_profit;
	return 0;
}